/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shared.utils.log;

import java.util.EnumMap;
import java.util.Map;
import net.skinsrestorer.shadow.jansi.Ansi;
import net.skinsrestorer.shared.utils.log.SRChatColor;

public class ANSIConverter {
    private static final Map<SRChatColor, String> replacements = new EnumMap<SRChatColor, String>(SRChatColor.class);
    private static final SRChatColor[] colors = SRChatColor.values();

    public static String convertToAnsi(String minecraftMessage) {
        String result = minecraftMessage;
        for (SRChatColor color : colors) {
            result = result.replaceAll("(?i)" + color.toString(), replacements.getOrDefault((Object)color, ""));
        }
        return result;
    }

    static {
        replacements.put(SRChatColor.BLACK, Ansi.ansi().fg(Ansi.Color.BLACK).boldOff().toString());
        replacements.put(SRChatColor.DARK_BLUE, Ansi.ansi().fg(Ansi.Color.BLUE).boldOff().toString());
        replacements.put(SRChatColor.DARK_GREEN, Ansi.ansi().fg(Ansi.Color.GREEN).boldOff().toString());
        replacements.put(SRChatColor.DARK_AQUA, Ansi.ansi().fg(Ansi.Color.CYAN).boldOff().toString());
        replacements.put(SRChatColor.DARK_RED, Ansi.ansi().fg(Ansi.Color.RED).boldOff().toString());
        replacements.put(SRChatColor.DARK_PURPLE, Ansi.ansi().fg(Ansi.Color.MAGENTA).boldOff().toString());
        replacements.put(SRChatColor.GOLD, Ansi.ansi().fg(Ansi.Color.YELLOW).boldOff().toString());
        replacements.put(SRChatColor.GRAY, Ansi.ansi().fg(Ansi.Color.WHITE).boldOff().toString());
        replacements.put(SRChatColor.DARK_GRAY, Ansi.ansi().fg(Ansi.Color.BLACK).bold().toString());
        replacements.put(SRChatColor.BLUE, Ansi.ansi().fg(Ansi.Color.BLUE).bold().toString());
        replacements.put(SRChatColor.GREEN, Ansi.ansi().fg(Ansi.Color.GREEN).bold().toString());
        replacements.put(SRChatColor.AQUA, Ansi.ansi().fg(Ansi.Color.CYAN).bold().toString());
        replacements.put(SRChatColor.RED, Ansi.ansi().fg(Ansi.Color.RED).bold().toString());
        replacements.put(SRChatColor.LIGHT_PURPLE, Ansi.ansi().fg(Ansi.Color.MAGENTA).bold().toString());
        replacements.put(SRChatColor.YELLOW, Ansi.ansi().fg(Ansi.Color.YELLOW).bold().toString());
        replacements.put(SRChatColor.WHITE, Ansi.ansi().fg(Ansi.Color.WHITE).bold().toString());
        replacements.put(SRChatColor.MAGIC, Ansi.ansi().a(Ansi.Attribute.BLINK_SLOW).toString());
        replacements.put(SRChatColor.BOLD, Ansi.ansi().a(Ansi.Attribute.UNDERLINE_DOUBLE).toString());
        replacements.put(SRChatColor.STRIKETHROUGH, Ansi.ansi().a(Ansi.Attribute.STRIKETHROUGH_ON).toString());
        replacements.put(SRChatColor.UNDERLINE, Ansi.ansi().a(Ansi.Attribute.UNDERLINE).toString());
        replacements.put(SRChatColor.ITALIC, Ansi.ansi().a(Ansi.Attribute.ITALIC).toString());
        replacements.put(SRChatColor.RESET, Ansi.ansi().a(Ansi.Attribute.RESET).fg(Ansi.Color.DEFAULT).toString());
    }
}

